<?php

namespace ReplyLive\Invitee;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invitee extends Model 
{

    protected $table = 'invitees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function activities()
    {
        return $this->belongsToMany('Activity')->using(ActivityInvitee::class)->withPivot('status');
    }

    public function breakouts()
    {
        return $this->belongsToMany('Breakout')->using(BreakoutInvitee::class)->withPivot('status');
    }

}